/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.controller;

import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import it.stefanot.gestionedvd.service.DvdInfoService;
import it.stefanot.gestionedvd.service.DvdService;
import it.stefanot.gestionedvd.service.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DvdController {
    private static final Logger logger = LoggerFactory.getLogger(DvdController.class);
    private final DvdInfoService dvdInfoService;
    private final DvdService dvdService;
    private final FileService fileService;

    public DvdController(DvdInfoService dvdInfoService, DvdService dvdService, FileService fileService) {
        this.dvdInfoService = dvdInfoService;
        this.dvdService = dvdService;
        this.fileService = fileService;
    }

    @RequestMapping(value={"/delete_dvd/{index}"})
    public String deleteDvd(Model model, @PathVariable Long index) {
        try {
            Dvd dvd = this.dvdService.getDvdByIndex(index);
            this.dvdService.removeDvd(index);
            model.addAttribute("message", (Object)(dvd.getNome() + " rimosso"));
        }
        catch (Exception e) {
            logger.error("Errore nel cancellare il dvd", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel cancellare il dvd");
        }
        model.addAttribute("listaDvd", (Object)this.dvdService.getListaDvd());
        return "redirect:/";
    }

    @RequestMapping(value={"/new_dvd"})
    public String newDvd(Model model) {
        try {
            Dvd dvd = new Dvd();
            model.addAttribute("dvd", (Object)dvd);
        }
        catch (Exception e) {
            logger.error("Errore nel creare il dvd", (Throwable)e);
        }
        return "viewDvd";
    }

    @RequestMapping(value={"/view_dvd/{index}"})
    public String viewDvd(Model model, @PathVariable Long index) {
        try {
            Dvd dvd = this.dvdService.getDvdByIndex(index);
            dvd.convertiPoster();
            model.addAttribute("dvd", (Object)dvd);
            model.addAttribute("index", (Object)index);
        }
        catch (Exception e) {
            logger.error("Errore nel visualizzare il dvd", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel visualizzare il dvd");
        }
        return "viewDvd";
    }

    @RequestMapping(value={"/download_dvd_tabella/{index}"})
    public String downloadDvdTabella(Model model, @PathVariable Long index) {
        Dvd dvd = this.dvdService.getDvdByIndex(index);
        this.dvdInfoService.scaricaInformazioniDvd(model, dvd);
        model.addAttribute("listaDvd", (Object)this.fileService.getListaDvd());
        return "index";
    }

    @PostMapping(value={"/download_dvd"})
    public String downloadDvd(Model model, Dvd dvd) {
        this.dvdInfoService.scaricaInformazioniDvd(model, dvd);
        model.addAttribute("dvd", (Object)dvd);
        return "viewDvd";
    }

    @PostMapping(value={"/save_dvd"})
    public String saveDvd(Model model, Dvd dvd) {
        Integer index = null;
        try {
            if (dvd.getNome() != null && !dvd.getNome().isEmpty()) {
                index = this.dvdService.saveOrUpdateDvd(dvd);
                model.addAttribute("message", (Object)"Film salvato correttamente");
            } else {
                model.addAttribute("messageError", (Object)"Indicare il titolo del film");
                model.addAttribute("dvd", (Object)dvd);
            }
        }
        catch (Exception e) {
            logger.error("Errore nel salvare il dvd", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel salvare il film");
        }
        model.addAttribute("dvd", (Object)dvd);
        model.addAttribute("listaDvd", (Object)this.dvdService.getListaDvd());
        model.addAttribute("index", (Object)index);
        return "viewDvd";
    }
}

