/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.controller;

import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import it.stefanot.gestionedvd.service.FileService;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class FileController {
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    @PostMapping(value={"/file_upload"})
    public String singleFileUpload(@RequestParam(value="file") MultipartFile file, Model model) {
        if (file.isEmpty()) {
            model.addAttribute("messageError", (Object)"Seleziona un file da caricare");
            return "uploadFile";
        }
        try {
            this.fileService.caricaFileSerialeOMXml(file);
            this.fileService.getListaDvd().ordina();
            model.addAttribute("listaDvd", (Object)this.fileService.getListaDvd());
            model.addAttribute("message", (Object)"File caricato correttamente");
        }
        catch (Exception e) {
            logger.error("Errore nel caricamento del file", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel caricamento del file");
        }
        return "index";
    }

    @RequestMapping(value={"/file_save"})
    public void fileSave(Model model, HttpServletResponse response) {
        try {
            ByteArrayOutputStream out = this.fileService.convertiListaDVDInXML();
            this.scriviOutputSuResponse(response, out, "attachment; filename=listaDvd.dvd", null);
        }
        catch (Exception e) {
            logger.error("Errore nel salvataggio del file", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel salvataggio del file");
        }
    }

    @RequestMapping(value={"/excel_save"})
    public void excelSave(Model model, HttpServletResponse response) {
        try {
            ByteArrayOutputStream outputStream = this.fileService.esportaExcel(this.fileService.getListaDvd());
            this.scriviOutputSuResponse(response, outputStream, null, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        catch (IOException e) {
            logger.error("Errore nel generare il file excel", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel generare il file excel");
        }
    }

    @RequestMapping(value={"/xml_save"})
    public void xmlSave(Model model, HttpServletResponse response) {
        try {
            ByteArrayOutputStream out = this.fileService.convertiListaDVDInXML();
            this.scriviOutputSuResponse(response, out, "attachment; filename=Lista Film.xml", "text/xml");
        }
        catch (JAXBException | IOException e) {
            logger.error("Errore nel generare il file xml", e);
            model.addAttribute("messageError", (Object)"Errore nel generare il file xml");
        }
    }

    @RequestMapping(value={"/pdf_save"})
    public void pdfSave(Model model, HttpServletResponse response) {
        try {
            ByteArrayOutputStream out = this.fileService.esportaPdf(this.fileService.getListaDvd());
            this.scriviOutputSuResponse(response, out, "attachment; filename=Lista Film.pdf", "application/pdf");
        }
        catch (Exception e) {
            logger.error("Errore nel salvataggio del file PDF", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel salvataggio del file");
        }
    }

    @PostMapping(value={"/locandina_upload"})
    public String locandinaUpload(@RequestParam(value="fileLocandina") MultipartFile fileLocandina, Model model, Dvd dvd) {
        if (fileLocandina.isEmpty()) {
            model.addAttribute("messageError", (Object)"Seleziona un file da caricare");
        } else {
            try {
                this.fileService.gestisciLocandina(fileLocandina, dvd);
                model.addAttribute("dvd", (Object)dvd);
                model.addAttribute("message", (Object)"Locandina caricata correttamente");
            }
            catch (Exception e) {
                logger.error("Errore nel caricamento della locandina", (Throwable)e);
                model.addAttribute("messageError", (Object)"Errore nel caricamento della locandina");
            }
        }
        return "viewDvd";
    }

    private void scriviOutputSuResponse(HttpServletResponse response, ByteArrayOutputStream out, String contentDisposition, String contentType) throws IOException {
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (contentDisposition != null) {
            response.addHeader("Content-Disposition", contentDisposition);
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());){
            IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
            response.flushBuffer();
            response.getOutputStream().flush();
        }
    }
}

