/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.controller;

import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import it.stefanot.gestionedvd.dto.ProcessingStatus;
import it.stefanot.gestionedvd.service.DvdInfoService;
import it.stefanot.gestionedvd.service.FileService;
import it.stefanot.gestionedvd.service.UtilitaService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"listaDvdUtilita"})
public class UtilitaController {
    private static final Logger logger = LoggerFactory.getLogger(UtilitaController.class);
    private final FileService fileService;
    private final DvdInfoService dvdInfoService;
    private final UtilitaService utilitaService;
    private final Map<String, ProcessingStatus> processingStatusMap = new ConcurrentHashMap();

    public UtilitaController(FileService fileService, DvdInfoService dvdInfoService, UtilitaService utilitaService) {
        this.fileService = fileService;
        this.dvdInfoService = dvdInfoService;
        this.utilitaService = utilitaService;
    }

    @RequestMapping(value={"/utilita_download"})
    public ResponseEntity<Map<String, Object>> utilitaDownload(HttpServletRequest request, HttpSession session) {
        String sessionId = request.getSession().getId();
        List utilitaLista = this.utilitaService.inizializzaListaUtilita();
        utilitaLista.removeIf(dvd -> dvd.getPosterString() != null && !dvd.getPosterString().isEmpty());
        ProcessingStatus status = new ProcessingStatus(utilitaLista.size());
        this.processingStatusMap.put(sessionId, status);
        CompletableFuture.runAsync(() -> this.dvdInfoService.processMoviesAsync(sessionId, utilitaLista, session, this.processingStatusMap));
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "started");
        response.put("totalItems", utilitaLista.size());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/utilita_supporto_anno_dvd"})
    public String showSupportoAnnoPage(Model model) {
        List utilitaLista = this.utilitaService.inizializzaListaUtilita();
        model.addAttribute("listaDvdUtilita", (Object)utilitaLista);
        model.addAttribute("fragmentType", (Object)"supporto_anno");
        return "utilita_tabella_dvd";
    }

    @GetMapping(value={"/utilita_tabella_dvd"})
    public String showUtilitaPage(@ModelAttribute(value="listaDvdUtilita") List<Dvd> utilitaLista, Model model) {
        model.addAttribute("listaDvdUtilita", utilitaLista);
        model.addAttribute("fragmentType", (Object)"download");
        return "utilita_tabella_dvd";
    }

    @GetMapping(value={"/utilita/status"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getProcessingStatus(HttpServletRequest request) {
        String sessionId = request.getSession().getId();
        ProcessingStatus status = (ProcessingStatus)this.processingStatusMap.get(sessionId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (status != null) {
            response.put("totalItems", status.getTotalItems());
            response.put("processedItems", status.getProcessedItems());
            response.put("currentMovie", status.getCurrentMovie());
            response.put("completed", status.isCompleted());
            if (status.isCompleted()) {
                response.put("processedMovies", status.getProcessedMovies());
                this.processingStatusMap.remove(sessionId);
            }
        } else {
            response.put("error", "No processing status found");
        }
        return ResponseEntity.ok(response);
    }

    @RequestMapping(value={"/utilita_ignore_dvd/{index}"})
    public String ignoreDvd(Model model, @PathVariable Long index, @ModelAttribute(value="listaDvdUtilita") List<Dvd> utilitaLista, SessionStatus status) {
        this.ignore(model, index, utilitaLista, status);
        model.addAttribute("fragmentType", (Object)"download");
        return "utilita_tabella_dvd";
    }

    @RequestMapping(value={"/utilita_ignore_supporto_anno_dvd/{index}"})
    public String ignoreSupportoAnnoDvd(Model model, @PathVariable Long index, @ModelAttribute(value="listaDvdUtilita") List<Dvd> utilitaLista, SessionStatus status) {
        this.ignore(model, index, utilitaLista, status);
        model.addAttribute("fragmentType", (Object)"supporto_anno");
        return "utilita_tabella_dvd";
    }

    private void ignore(Model model, Long index, List<Dvd> utilitaLista, SessionStatus status) {
        try {
            if (!utilitaLista.isEmpty()) {
                Dvd dvd = utilitaLista.get(index.intValue());
                utilitaLista.remove(index.intValue());
                model.addAttribute("message", (Object)(dvd.getNome() + " ignorato"));
            }
            if (utilitaLista.isEmpty()) {
                status.setComplete();
            }
        }
        catch (Exception e) {
            logger.error("Errore nell' ignorare il dvd", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nell' ignorare il dvd");
        }
        model.addAttribute("listaDvdUtilita", utilitaLista);
    }

    @RequestMapping(value={"/utilita_conferma_dvd/{index}"})
    public String confermaDvd(Model model, @PathVariable Long index, @ModelAttribute(value="listaDvdUtilita") List<Dvd> utilitaLista, SessionStatus status) {
        List listaFileService = this.fileService.getListaDvd().getListaDvd();
        try {
            if (!utilitaLista.isEmpty()) {
                Dvd dvd = utilitaLista.get(index.intValue());
                for (int i = 0; i < listaFileService.size(); ++i) {
                    Dvd dvdFileService = (Dvd)listaFileService.get(i);
                    if (!dvdFileService.getId().equals(dvd.getId())) continue;
                    listaFileService.remove(dvdFileService);
                    listaFileService.add(dvd);
                    utilitaLista.remove(dvd);
                    break;
                }
                model.addAttribute("message", (Object)(dvd.getNome() + " aggiornato"));
                if (utilitaLista.isEmpty()) {
                    status.setComplete();
                }
            }
        }
        catch (Exception e) {
            logger.error("Errore nel confermare il dvd ", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel confermare il dvd");
        }
        model.addAttribute("listaDvd", (Object)listaFileService);
        model.addAttribute("listaDvdUtilita", utilitaLista);
        model.addAttribute("fragmentType", (Object)"download");
        return "utilita_tabella_dvd";
    }

    @RequestMapping(value={"/utilita_conferma_supporto_anno_dvd"})
    public String confermaDvdSupportoAnno(Model model, @ModelAttribute(value="listaDvdUtilita") List<Dvd> utilitaLista, @RequestParam int supporto, @RequestParam int anno, @RequestParam Long id) {
        List listaFileService = this.fileService.getListaDvd().getListaDvd();
        try {
            Dvd dvdDaSalvare;
            if (!listaFileService.isEmpty() && (dvdDaSalvare = (Dvd)listaFileService.stream().filter(dvd -> dvd.getId().equals(id)).findFirst().orElse(null)) != null) {
                dvdDaSalvare.setSupporto(Integer.valueOf(supporto));
                dvdDaSalvare.setAnno(anno);
                utilitaLista.removeIf(dvd -> dvd.getId().equals(id));
                model.addAttribute("message", (Object)(dvdDaSalvare.getNome() + " aggiornato"));
            }
        }
        catch (Exception e) {
            logger.error("Errore nel confermare il dvd ", (Throwable)e);
            model.addAttribute("messageError", (Object)"Errore nel confermare il dvd");
        }
        model.addAttribute("listaDvd", (Object)listaFileService);
        model.addAttribute("listaDvdUtilita", utilitaLista);
        model.addAttribute("fragmentType", (Object)"supporto_anno");
        return "utilita_tabella_dvd";
    }
}

