/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressibleInputStream
extends ObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(DecompressibleInputStream.class);

    public DecompressibleInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> localClass;
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        try {
            localClass = Class.forName(resultClassDescriptor.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("No local class for {}", (Object)resultClassDescriptor.getName(), (Object)e);
            return resultClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long streamSUID = resultClassDescriptor.getSerialVersionUID();
            if (streamSUID != localSUID) {
                String msg = String.format("Overriding serialized class version mismatch: local serialVersionUID = %d, stream serialVersionUID = %d", localSUID, streamSUID);
                logger.error("SerialVersionUID mismatch: {}", (Object)msg);
            }
        }
        return resultClassDescriptor;
    }
}

