/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.service;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import gestionedvd.it.stefanot.gestionedvd.modello.ListaDvd;
import it.stefanot.gestionedvd.service.DecompressibleInputStream;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    private ListaDvd listaDvd = new ListaDvd();

    public void caricaXMl(MultipartFile file) throws IOException, JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ListaDvd.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        this.listaDvd = (ListaDvd)jaxbUnmarshaller.unmarshal(file.getInputStream());
    }

    public void caricaSerial(MultipartFile file) throws IOException, ClassNotFoundException {
        DecompressibleInputStream dis = new DecompressibleInputStream(file.getInputStream());
        this.listaDvd = (ListaDvd)dis.readObject();
        for (int i = 0; this.listaDvd.getListaDvd().size() > i; ++i) {
            Dvd dvd = (Dvd)this.listaDvd.getListaDvd().get(i);
            dvd.setId(Long.valueOf(i));
        }
    }

    public ByteArrayOutputStream esportaPdf(ListaDvd lista) throws DocumentException, IOException {
        Document documentoPdf = new Document();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PdfWriter.getInstance((Document)documentoPdf, (OutputStream)out);
        documentoPdf.open();
        Font titoloFont = FontFactory.getFont((String)"Helvetica-Bold", (float)18.0f, (BaseColor)BaseColor.BLUE);
        Font normaleFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (BaseColor)BaseColor.BLACK);
        Paragraph titolo = new Paragraph("Lista Film", titoloFont);
        titolo.setAlignment(1);
        documentoPdf.add((Element)titolo);
        documentoPdf.add((Element)new Paragraph(" "));
        for (Dvd dvd : lista.getListaDvd()) {
            PdfPCell posterCell;
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.setWidths(new float[]{1.0f, 4.0f});
            table.setSpacingBefore(5.0f);
            table.setSpacingAfter(5.0f);
            table.setKeepTogether(true);
            if (dvd.getPosterString() != null && !dvd.getPosterString().isEmpty()) {
                byte[] imageBytes = Base64.getDecoder().decode(dvd.getPosterString());
                com.itextpdf.text.Image posterImage = com.itextpdf.text.Image.getInstance((byte[])imageBytes);
                posterImage.scaleToFit(80.0f, 100.0f);
                posterCell = new PdfPCell(posterImage, false);
            } else {
                posterCell = new PdfPCell((Phrase)new Paragraph("N/A", normaleFont));
            }
            posterCell.setBorder(15);
            posterCell.setPadding(5.0f);
            posterCell.setHorizontalAlignment(1);
            posterCell.setVerticalAlignment(5);
            table.addCell(posterCell);
            PdfPCell dettagliCell = new PdfPCell();
            dettagliCell.setBorder(15);
            dettagliCell.setPadding(5.0f);
            dettagliCell.addElement((Element)new Paragraph("Titolo: " + dvd.getNome(), normaleFont));
            dettagliCell.addElement((Element)new Paragraph("Anno: " + dvd.getAnno(), normaleFont));
            dettagliCell.addElement((Element)new Paragraph("Regista: " + dvd.getRegista(), normaleFont));
            dettagliCell.addElement((Element)new Paragraph("Attori: " + dvd.getAttorePri() + ", " + dvd.getAttoreSec(), normaleFont));
            dettagliCell.addElement((Element)new Paragraph("Oscar: " + dvd.getOscar(), normaleFont));
            table.addCell(dettagliCell);
            documentoPdf.add((Element)table);
            documentoPdf.add((Element)new Paragraph(" "));
        }
        documentoPdf.add((Element)new Paragraph("Totale: " + lista.getNumeroDvd(), titoloFont));
        documentoPdf.close();
        return out;
    }

    public ByteArrayOutputStream convertiListaDVDInXML() throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ListaDvd lista = this.getListaDvd();
        for (Dvd dvd : lista.getListaDvd()) {
            dvd.convertiPoster();
        }
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{ListaDvd.class});
        Marshaller marshallerObj = contextObj.createMarshaller();
        marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
        marshallerObj.marshal((Object)lista, (OutputStream)out);
        return out;
    }

    public ByteArrayOutputStream esportaExcel(ListaDvd lista) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            ByteArrayOutputStream byteArrayOutputStream;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                XSSFSheet sheet = workbook.createSheet("Dvd");
                this.writeHeaderLine(sheet);
                this.writeDataLines(sheet, lista);
                workbook.write((OutputStream)outputStream);
                byteArrayOutputStream = outputStream;
            }
            return byteArrayOutputStream;
        }
    }

    private void writeHeaderLine(XSSFSheet sheet) {
        XSSFRow headerRow = sheet.createRow(0);
        String[] headers = new String[]{"Supporto", "Titolo", "Anno di produzione", "Codice", "Durata", "Casa di produzione", "Regista", "Attore principale", "Attore secondario", "Altri attori", "Oscar ricevuti", "Lingue audio", "Dati prestito"};
        for (int i = 0; i < headers.length; ++i) {
            Cell headerCell = headerRow.createCell(i);
            headerCell.setCellValue(headers[i]);
        }
    }

    private void writeDataLines(XSSFSheet sheet, ListaDvd lista) {
        int rowCount = 1;
        for (Dvd dvd : lista.getListaDvd()) {
            XSSFRow row = sheet.createRow(rowCount++);
            row.createCell(0).setCellValue(dvd.getSupportoDescrizione());
            row.createCell(1).setCellValue(dvd.getNome());
            row.createCell(2).setCellValue("" + dvd.getAnno());
            row.createCell(3).setCellValue(dvd.getCodice() == null ? "" : dvd.getCodice());
            row.createCell(4).setCellValue("" + dvd.getMinuti());
            row.createCell(5).setCellValue(dvd.getCasaProduzione());
            row.createCell(6).setCellValue(dvd.getRegista());
            row.createCell(7).setCellValue(dvd.getAttorePri());
            row.createCell(8).setCellValue(dvd.getAttoreSec());
            row.createCell(9).setCellValue(dvd.getAltriAttori());
            row.createCell(10).setCellValue("" + dvd.getOscar());
            row.createCell(11).setCellValue(dvd.getAudio());
            row.createCell(12).setCellValue(dvd.getPrestito());
        }
    }

    public void caricaFileSerialeOMXml(MultipartFile file) throws IOException, JAXBException {
        try {
            this.caricaSerial(file);
        }
        catch (Exception e) {
            this.caricaXMl(file);
        }
    }

    public void gestisciLocandina(MultipartFile fileLocandina, Dvd dvd) throws IOException {
        Image poster = ImageIO.read(fileLocandina.getInputStream());
        poster = dvd.resizePoster(poster);
        dvd.setPoster((Icon)new ImageIcon(poster));
        dvd.convertiPoster();
    }

    public ListaDvd getListaDvd() {
        return this.listaDvd;
    }
}

