/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.service;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VersionService {
    private static final Logger logger = LoggerFactory.getLogger(VersionService.class);
    private static final String VERSION_ENDPOINT = "http://www.cinemaland.it/api/software/gestionedvd/latest";
    private static final URI BASE_URI = URI.create("http://www.cinemaland.it");
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    @Value(value="${application.version}")
    private String versioneApplicazione;

    public String controlloNuovaVersione() {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(VERSION_ENDPOINT)).timeout(Duration.ofSeconds(5L)).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (response.statusCode() != 200) {
                logger.warn("Controllo versione fallito: status {}", (Object)response.statusCode());
                return null;
            }
            JSONObject payload = new JSONObject(response.body());
            String versioneOnline = payload.optString("version");
            if (versioneOnline.isBlank()) {
                logger.warn("Risposta controllo versione senza campo 'version': {}", (Object)response.body());
                return null;
            }
            logger.info("Versione applicazione: {}", (Object)this.versioneApplicazione);
            logger.info("Nuova versione online: {}", (Object)versioneOnline);
            if (this.isNewerVersion(this.versioneApplicazione, versioneOnline)) {
                String downloadPath = payload.optString("url");
                if (downloadPath.isBlank()) {
                    logger.warn("Versione {} disponibile ma campo 'url' mancante nella risposta", (Object)versioneOnline);
                    return null;
                }
                String downloadUrl = BASE_URI.resolve(downloadPath).toString();
                logger.info("URL download nuova versione: {}", (Object)downloadUrl);
                return downloadUrl;
            }
        }
        catch (IOException e) {
            logger.error("Errore nel controllo versione", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Controllo versione interrotto", (Throwable)e);
        }
        catch (JSONException e) {
            logger.error("Risposta controllo versione non valida", (Throwable)e);
        }
        return null;
    }

    private boolean isNewerVersion(String versioneLocal, String versioneOnline) {
        if (versioneOnline == null || versioneOnline.isBlank()) {
            return false;
        }
        if (versioneLocal == null || versioneLocal.isBlank()) {
            return true;
        }
        String[] currentParts = versioneLocal.split("\\.");
        String[] onlineParts = versioneOnline.split("\\.");
        int length = Math.max(currentParts.length, onlineParts.length);
        for (int i = 0; i < length; ++i) {
            int current = this.parseVersionComponent(currentParts, i);
            int online = this.parseVersionComponent(onlineParts, i);
            if (online > current) {
                return true;
            }
            if (online >= current) continue;
            return false;
        }
        return false;
    }

    private int parseVersionComponent(String[] parts, int index) {
        if (index >= parts.length) {
            return 0;
        }
        String part = parts[index];
        StringBuilder digits = new StringBuilder();
        for (char c : part.toCharArray()) {
            if (!Character.isDigit(c)) break;
            digits.append(c);
        }
        if (digits.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(digits.toString());
        }
        catch (NumberFormatException e) {
            logger.warn("Impossibile analizzare la componente di versione '{}'", (Object)part, (Object)e);
            return 0;
        }
    }
}

