/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.Environment;

@SpringBootApplication
public class GestioneDvdApplication
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(GestioneDvdApplication.class);
    private final Environment env;

    public GestioneDvdApplication(Environment env) {
        this.env = env;
    }

    public static void main(String[] args) {
        SpringApplication.run(GestioneDvdApplication.class, (String[])args);
    }

    public void run(String ... args) {
        String url = "http://localhost:" + this.env.getProperty("server.port");
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                logger.error("Errore nell'aprire il browser", (Throwable)e);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
            }
            catch (IOException e) {
                logger.error("Errore nell'aprire il browser", (Throwable)e);
            }
        }
    }
}

