/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.controller;

import it.stefanot.gestionedvd.service.FileService;
import it.stefanot.gestionedvd.service.VersionService;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class HomeController {
    private final ApplicationContext appContext;
    private final FileService fileService;
    private final VersionService versionService;

    public HomeController(ApplicationContext appContext, FileService fileService, VersionService versionService) {
        this.appContext = appContext;
        this.fileService = fileService;
        this.versionService = versionService;
    }

    @GetMapping(value={"/home"})
    public String home(Model model) {
        this.prepareHomeIndex(model);
        return "index";
    }

    @GetMapping(value={"/"})
    public String index(Model model) {
        this.prepareHomeIndex(model);
        return "index";
    }

    private void prepareHomeIndex(Model model) {
        this.fileService.getListaDvd().ordina();
        model.addAttribute("listaDvd", (Object)this.fileService.getListaDvd());
        String linkNuovaVersione = this.versionService.controlloNuovaVersione();
        if (linkNuovaVersione != null) {
            model.addAttribute("linkNewVersion", (Object)linkNuovaVersione);
        }
    }

    @GetMapping(value={"/file_upload_view"})
    public String fileUploadView() {
        return "uploadFile";
    }

    @GetMapping(value={"/exit"})
    public void exit() {
        SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
    }

    @GetMapping(value={"/utilita_view"})
    public String utilitaView() {
        return "utilita";
    }
}

