/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.dto;

import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import java.util.List;

public class ProcessingStatus {
    private int totalItems;
    private int processedItems;
    private String currentMovie;
    private boolean completed;
    private List<Dvd> processedMovies;

    public ProcessingStatus() {
    }

    public ProcessingStatus(int totalItems) {
        this.totalItems = totalItems;
        this.processedItems = 0;
        this.currentMovie = "Inizializzazione...";
        this.completed = false;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public int getProcessedItems() {
        return this.processedItems;
    }

    public void setProcessedItems(int processedItems) {
        this.processedItems = processedItems;
    }

    public String getCurrentMovie() {
        return this.currentMovie;
    }

    public void setCurrentMovie(String currentMovie) {
        this.currentMovie = currentMovie;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public List<Dvd> getProcessedMovies() {
        return this.processedMovies;
    }

    public void setProcessedMovies(List<Dvd> processedMovies) {
        this.processedMovies = processedMovies;
    }

    public double getProgressPercentage() {
        if (this.totalItems == 0) {
            return 0.0;
        }
        return (double)this.processedItems / (double)this.totalItems * 100.0;
    }

    public int getRemainingItems() {
        return Math.max(0, this.totalItems - this.processedItems);
    }

    public void incrementProcessed() {
        ++this.processedItems;
    }

    public void incrementProcessed(String nextMovie) {
        ++this.processedItems;
        this.currentMovie = nextMovie;
    }

    public String toString() {
        return "ProcessingStatus{totalItems=" + this.totalItems + ", processedItems=" + this.processedItems + ", currentMovie='" + this.currentMovie + "', completed=" + this.completed + ", progressPercentage=" + String.format("%.1f", this.getProgressPercentage()) + "%}";
    }
}

