/*
 * Decompiled with CFR 0.152.
 */
package it.stefanot.gestionedvd.service;

import gestionedvd.it.stefanot.gestionedvd.modello.Dvd;
import it.stefanot.gestionedvd.dto.ProcessingStatus;
import jakarta.servlet.http.HttpSession;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class DvdInfoService {
    private static final Logger logger = LoggerFactory.getLogger(DvdInfoService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dvd scaricaInformazioniDvd(Model model, Dvd dvd) {
        String anno;
        String nomeDvd = dvd.getNome();
        String string = anno = dvd.getAnno() == 0 ? "" : "" + dvd.getAnno();
        if (StringUtils.isBlank((CharSequence)nomeDvd) && model != null) {
            model.addAttribute("messageError", (Object)"Indicare il titolo del film");
            return null;
        }
        String lingua = System.getProperty("user.language");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject film = this.cercaFilm(httpClient, nomeDvd, anno, lingua);
            if (film == null) {
                if (model != null) {
                    model.addAttribute("messageError", (Object)"Film non trovato");
                }
                Dvd dvd2 = null;
                return dvd2;
            }
            this.aggiornaDatiBaseDvd(dvd, film);
            String idFilm = film.get("id").toString();
            JSONObject dettagli = this.scaricaDettagliFilm(httpClient, idFilm, lingua);
            this.aggiornaDettagliDvd(dvd, dettagli);
            return dvd;
        }
        catch (JSONException je) {
            if (model == null) return dvd;
            model.addAttribute("messageError", (Object)"Film non trovato");
            return null;
        }
        catch (Exception e) {
            if (model == null) return dvd;
            model.addAttribute("messageError", (Object)"Errore nel recuperare le informazioni del film");
            return null;
        }
    }

    private JSONObject cercaFilm(CloseableHttpClient httpClient, String nome, String anno, String lingua) throws IOException {
        JSONObject result = this.cercaFilmConParametri(httpClient, nome, anno, lingua, true);
        if (result != null) {
            return result;
        }
        result = this.cercaFilmConParametri(httpClient, nome, anno, lingua, false);
        if (result != null) {
            return result;
        }
        result = this.cercaFilmSimilaritaMassima(httpClient, nome, lingua);
        return result;
    }

    private JSONObject cercaFilmConParametri(CloseableHttpClient httpClient, String nome, String anno, String lingua, boolean usaAnno) throws IOException {
        JSONObject response;
        String query = nome.replace(" ", "+");
        String url = "https://api.themoviedb.org/3/search/movie?api_key=6c2a1bf952df52322c7afda0627c3f2b&language=" + lingua + "&query=" + query;
        if (usaAnno && anno.length() == 4) {
            url = url + "&year=" + anno;
        }
        if ((response = this.eseguiHttpRequest(httpClient, url)) == null) {
            return null;
        }
        JSONArray results = response.optJSONArray("results");
        if (results == null || results.length() == 0) {
            return null;
        }
        if (results.length() == 1) {
            return results.getJSONObject(0);
        }
        return usaAnno && anno.length() == 4 ? this.trovaBestMatchConAnno(results, nome, anno) : this.trovaBestMatchSenzaAnno(results, nome);
    }

    private JSONObject cercaFilmSimilaritaMassima(CloseableHttpClient httpClient, String nome, String lingua) throws IOException {
        String query = nome.replace(" ", "+");
        String url = "https://api.themoviedb.org/3/search/movie?api_key=6c2a1bf952df52322c7afda0627c3f2b&language=" + lingua + "&query=" + query;
        JSONObject response = this.eseguiHttpRequest(httpClient, url);
        if (response == null) {
            return null;
        }
        JSONArray results = response.optJSONArray("results");
        if (results == null || results.length() == 0) {
            return null;
        }
        return this.trovaBestMatchSenzaAnno(results, nome);
    }

    private JSONObject trovaBestMatchConAnno(JSONArray results, String nome, String anno) {
        LevenshteinDistance distance = new LevenshteinDistance();
        String titoloCercato = nome.toLowerCase();
        JSONObject bestMatch = null;
        int bestScore = Integer.MAX_VALUE;
        int bestPopularity = -1;
        for (int i = 0; i < results.length(); ++i) {
            int popularity;
            int score;
            JSONObject film = results.getJSONObject(i);
            String releaseDate = film.optString("release_date", "");
            if (!releaseDate.startsWith(anno) || !this.isBetterMatch(score = this.calcolaScore(distance, titoloCercato, film), popularity = film.optInt("popularity", 0), bestScore, bestPopularity)) continue;
            bestMatch = film;
            bestScore = score;
            bestPopularity = popularity;
        }
        if (bestMatch == null) {
            bestMatch = this.trovaBestMatchSenzaAnno(results, nome);
        }
        return bestMatch;
    }

    private JSONObject trovaBestMatchSenzaAnno(JSONArray results, String nome) {
        LevenshteinDistance distance = new LevenshteinDistance();
        String titoloCercato = this.normalize(nome);
        JSONObject bestMatch = null;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject film = results.getJSONObject(i);
            String titolo = this.normalize(film.optString("title", ""));
            String titoloOriginale = this.normalize(film.optString("original_title", ""));
            if (titolo.contains(titoloCercato) || titoloOriginale.contains(titoloCercato)) {
                return film;
            }
            int score = Math.min(distance.apply((CharSequence)titoloCercato, (CharSequence)titolo), distance.apply((CharSequence)titoloCercato, (CharSequence)titoloOriginale));
            double finalScore = (double)score - film.optDouble("popularity", 0.0) / 10.0;
            if (!(finalScore < bestScore)) continue;
            bestMatch = film;
            bestScore = finalScore;
        }
        return bestMatch;
    }

    private String normalize(String s) {
        if (s == null) {
            return "";
        }
        String temp = s.toLowerCase().trim();
        temp = Normalizer.normalize(temp, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
        temp = temp.replaceAll("[^a-z0-9 ]", "");
        return temp;
    }

    private int calcolaScore(LevenshteinDistance distance, String titoloCercato, JSONObject film) {
        String titolo = film.optString("title", "").toLowerCase();
        String titoloOriginale = film.optString("original_title", "").toLowerCase();
        return Math.min(distance.apply((CharSequence)titoloCercato, (CharSequence)titolo), distance.apply((CharSequence)titoloCercato, (CharSequence)titoloOriginale));
    }

    private boolean isBetterMatch(int score, int popularity, int bestScore, int bestPopularity) {
        return score < bestScore || score == bestScore && popularity > bestPopularity;
    }

    private JSONObject scaricaDettagliFilm(CloseableHttpClient httpClient, String idFilm, String lingua) throws IOException {
        String url = "https://api.themoviedb.org/3/movie/" + idFilm + "?api_key=6c2a1bf952df52322c7afda0627c3f2b&append_to_response=credits&language=" + lingua;
        return this.eseguiHttpRequest(httpClient, url);
    }

    private JSONObject eseguiHttpRequest(CloseableHttpClient httpClient, String url) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(url));){
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            String json = EntityUtils.toString((HttpEntity)entity);
            JSONObject jSONObject = new JSONObject(json);
            return jSONObject;
        }
    }

    private void aggiornaDatiBaseDvd(Dvd dvd, JSONObject film) throws IOException {
        String releaseDate = film.optString("release_date", "0000-00-00");
        dvd.setAnno(Integer.parseInt(releaseDate.substring(0, 4)));
        String nomeOriginale = dvd.getNome();
        dvd.setNomeOriginale(nomeOriginale);
        dvd.setNome(WordUtils.capitalize((String)film.getString("title")));
        dvd.setTrama(film.optString("overview", ""));
        String posterPath = film.optString("poster_path", "");
        if (!posterPath.isEmpty()) {
            Image poster = ImageIO.read(new URL("http://image.tmdb.org/t/p/w500/" + posterPath));
            poster = dvd.resizePoster(poster);
            dvd.setPoster((Icon)new ImageIcon(poster));
            dvd.convertiPoster();
        }
    }

    private void aggiornaDettagliDvd(Dvd dvd, JSONObject dettagli) {
        dvd.setMinuti(dettagli.optInt("runtime", 0));
        this.aggiornaGenere(dvd, dettagli);
        this.aggiornaCasaProduzione(dvd, dettagli);
        this.aggiornaCast(dvd, dettagli);
        this.aggiornaRegista(dvd, dettagli);
    }

    private void aggiornaGenere(Dvd dvd, JSONObject dettagli) {
        JSONArray genres = dettagli.optJSONArray("genres");
        if (genres != null && genres.length() > 0) {
            ArrayList<String> generi = new ArrayList<String>();
            for (int i = 0; i < genres.length(); ++i) {
                generi.add(genres.getJSONObject(i).getString("name"));
            }
            dvd.setGenere(String.join((CharSequence)",", generi));
        }
    }

    private void aggiornaCasaProduzione(Dvd dvd, JSONObject dettagli) {
        JSONArray companies = dettagli.optJSONArray("production_companies");
        if (companies != null && companies.length() > 0) {
            dvd.setCasaProduzione(companies.getJSONObject(0).getString("name"));
        }
    }

    private void aggiornaCast(Dvd dvd, JSONObject dettagli) {
        JSONObject credits = dettagli.optJSONObject("credits");
        if (credits == null) {
            return;
        }
        JSONArray cast = credits.optJSONArray("cast");
        if (cast != null) {
            if (cast.length() > 0) {
                dvd.setAttorePri(cast.getJSONObject(0).getString("name"));
            }
            if (cast.length() > 1) {
                dvd.setAttoreSec(cast.getJSONObject(1).getString("name"));
            }
            if (cast.length() > 2) {
                dvd.setAltriAttori(cast.getJSONObject(2).getString("name"));
            }
        }
    }

    private void aggiornaRegista(Dvd dvd, JSONObject dettagli) {
        JSONObject credits = dettagli.optJSONObject("credits");
        if (credits == null) {
            return;
        }
        JSONArray crew = credits.optJSONArray("crew");
        if (crew != null) {
            for (int i = 0; i < crew.length(); ++i) {
                JSONObject person = crew.getJSONObject(i);
                if (!"Director".equals(person.getString("job"))) continue;
                dvd.setRegista(person.getString("name"));
                break;
            }
        }
    }

    public void processMoviesAsync(String sessionId, List<Dvd> utilitaLista, HttpSession session, Map<String, ProcessingStatus> processingStatusMap) {
        ProcessingStatus status = processingStatusMap.get(sessionId);
        ArrayList<Dvd> processedList = new ArrayList<Dvd>();
        for (Dvd dvd2 : utilitaLista) {
            status.setCurrentMovie(dvd2.getNome());
            try {
                logger.info("Scarico le informazioni del film: {}", (Object)dvd2.getNome());
                Dvd dvdScaricato = this.scaricaInformazioniDvd(null, dvd2);
                if (dvdScaricato != null) {
                    processedList.add(dvdScaricato);
                }
            }
            catch (Exception e) {
                logger.error("Errore nel scaricare le informazioni del film: {}", (Object)dvd2.getNome(), (Object)e);
            }
            status.incrementProcessed();
        }
        utilitaLista.removeIf(dvd -> dvd.getPosterString() == null || dvd.getPosterString().isEmpty());
        session.setAttribute("listaDvdUtilita", utilitaLista);
        status.setCurrentMovie("Finalizzazione...");
        status.setCompleted(true);
        status.setProcessedMovies(processedList);
    }
}

