# Script PowerShell per scaricare automaticamente i Google Fonts
# Esegui questo script dalla directory fonts

Write-Host "Download Google Fonts per GestioneDVD..." -ForegroundColor Green
Write-Host ""

$fontsDir = $PSScriptRoot

# URL base per Google Webfonts Helper
$poppinsBase = "https://gwfh.mranftl.com/api/fonts/poppins"
$robotoBase = "https://gwfh.mranftl.com/api/fonts/roboto"

# Array di font da scaricare
$fonts = @(
    @{Name="poppins-v20-latin-300"; Url="https://github.com/google/fonts/raw/main/ofl/poppins/Poppins-Light.ttf"},
    @{Name="poppins-v20-latin-regular"; Url="https://github.com/google/fonts/raw/main/ofl/poppins/Poppins-Regular.ttf"},
    @{Name="poppins-v20-latin-500"; Url="https://github.com/google/fonts/raw/main/ofl/poppins/Poppins-Medium.ttf"},
    @{Name="poppins-v20-latin-600"; Url="https://github.com/google/fonts/raw/main/ofl/poppins/Poppins-SemiBold.ttf"},
    @{Name="poppins-v20-latin-700"; Url="https://github.com/google/fonts/raw/main/ofl/poppins/Poppins-Bold.ttf"},
    @{Name="roboto-v30-latin-300"; Url="https://github.com/google/fonts/raw/main/apache/roboto/static/Roboto-Light.ttf"},
    @{Name="roboto-v30-latin-regular"; Url="https://github.com/google/fonts/raw/main/apache/roboto/static/Roboto-Regular.ttf"},
    @{Name="roboto-v30-latin-500"; Url="https://github.com/google/fonts/raw/main/apache/roboto/static/Roboto-Medium.ttf"},
    @{Name="roboto-v30-latin-600"; Url="https://github.com/google/fonts/raw/main/apache/roboto/static/Roboto-Bold.ttf"},
    @{Name="roboto-v30-latin-700"; Url="https://github.com/google/fonts/raw/main/apache/roboto/static/Roboto-Black.ttf"}
)

Write-Host "ATTENZIONE: Questo script scarica i file TTF da GitHub." -ForegroundColor Yellow
Write-Host "Dovrai convertirli in WOFF e WOFF2 manualmente usando un tool online come:" -ForegroundColor Yellow
Write-Host "  - https://transfonter.org/" -ForegroundColor Cyan
Write-Host "  - https://cloudconvert.com/ttf-to-woff2" -ForegroundColor Cyan
Write-Host ""
Write-Host "ALTERNATIVA CONSIGLIATA:" -ForegroundColor Yellow
Write-Host "Visita https://gwfh.mranftl.com/fonts e scarica direttamente i file WOFF/WOFF2" -ForegroundColor Cyan
Write-Host ""

$response = Read-Host "Vuoi procedere con il download dei file TTF? (s/n)"
if ($response -ne "s") {
    Write-Host "Download annullato. Usa il metodo manuale descritto in README.md" -ForegroundColor Yellow
    exit
}

Write-Host ""
Write-Host "Download in corso..." -ForegroundColor Green

foreach ($font in $fonts) {
    $ttfFile = Join-Path $fontsDir "$($font.Name).ttf"
    Write-Host "Downloading $($font.Name).ttf..." -NoNewline
    try {
        Invoke-WebRequest -Uri $font.Url -OutFile $ttfFile -ErrorAction Stop
        Write-Host " OK" -ForegroundColor Green
    } catch {
        Write-Host " ERRORE" -ForegroundColor Red
        Write-Host "  Errore: $_" -ForegroundColor Red
    }
}

Write-Host ""
Write-Host "Download completato!" -ForegroundColor Green
Write-Host ""
Write-Host "PROSSIMI PASSI:" -ForegroundColor Yellow
Write-Host "1. Converti i file TTF in WOFF e WOFF2 usando https://transfonter.org/" -ForegroundColor White
Write-Host "2. Carica i file WOFF e WOFF2 nella cartella fonts/" -ForegroundColor White
Write-Host "3. Elimina i file TTF (opzionale)" -ForegroundColor White
Write-Host ""
